<?php

#error_reporting(E_ALL); // Meldet alle Fehler
#ini_set('display_errors', 1); // Zeigt die Fehler im Browser an
#ini_set('display_startup_errors', 1); // Zeigt auch Fehler, die beim Start von PHP auftreten

#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 18.01.2025

// Session
session_start();

// Laden der Konfigurationsdatei für MySQL-Datenbankverbindung und LDAP-Anbindung
require_once $_SERVER['DOCUMENT_ROOT'] . '/config.inc.php';

// Setzen der Zeitzone für die gesamte Anwendung
date_default_timezone_set($app_config['timezone']);

// Seitentitel übergeben
function pageName($name)
{
    global $pageName;
    $pageName = $name;
}

// Datenbankverbindung herstellen
function initializeDatabaseConnection()
{

    include('config.inc.php');
    global $dsn, $pdo;

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
}

// Funktion, die prüft, ob die Datei inkludiert oder direkt aufgerufen wird
function requireIncluded($basename_file)
{ // basename(__FILE__)
    if ($basename_file == basename($_SERVER['SCRIPT_FILENAME'])) {
        include('assets/ErrorDocuments/403.php');
        exit;
    }
}

// Funktion zur Überprüfung ob der Login erforderlich ist
function requireLogin()
{
    if (!$_SESSION['LoggedIn'] == true) {
        header('location: /login');
        exit;
    }
}

// Funktion für den Wartungsmodus (Noch in Bearbeitung)
function maintenanceMode()
{

}

// Funktion zur Überprüfung der Benutzerrolle
function requireRole($requiredRoles)
{

    $userRoles = $_SESSION['Role'];

    if (!is_array($requiredRoles)) {
        $requiredRoles = [$requiredRoles];
    }

    if (in_array($userRoles, $requiredRoles)) {
        return true;
    } else {
        include('assets/ErrorDocuments/403.php');
        exit;
    }
}

// Funktion zur Ausgabe von HTML, wenn der Benutzer in der angegebenen Rolle ist
function showIfRole($requiredRoles, $htmlContent)
{
    if (!isset($_SESSION['Role'])) {
        return;
    }

    if (!is_array($requiredRoles)) {
        $requiredRoles = [$requiredRoles];
    }

    $userRole = $_SESSION['Role'];

    if (in_array($userRole, $requiredRoles)) {
        echo $htmlContent;
    }
}

// Funktion zum Einfügen eines Audit-Log-Eintrags
function addAuditLog($user, $type, $description)
{

    include('config.inc.php');

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = "INSERT INTO AuditLogs (Username, Type, Description, IPAddress, Timestamp) 
                VALUES (:username, :type, :description, :ip_address, :timestamp)";

    $stmt = $pdo->prepare($sql);

    $stmt->bindParam(':username', $user);
    $stmt->bindParam(':type', $type);
    $stmt->bindParam(':description', $description);
    $stmt->bindParam(':ip_address', $_SERVER['REMOTE_ADDR']);
    $stmt->bindParam(':timestamp', date('Y-m-d H:i:s'));

    $stmt->execute();

}

// Funktion zum Einfügen eines Buchungshistorien-Eintrages
function addBookingHistory($ZoneLeft, $ZoneEntered, $AccessCard, $FullName)
{

    include('config.inc.php');

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = "INSERT INTO BookingHistory (ZoneLeft, ZoneEntered, AccessCard, FullName, Timestamp) 
                VALUES (:ZoneLeft, :ZoneEntered, :AccessCard, :FullName, :Timestamp)";

    $stmt = $pdo->prepare($sql);

    $stmt->bindParam(':ZoneLeft', $ZoneLeft);
    $stmt->bindParam(':ZoneEntered', $ZoneEntered);
    $stmt->bindParam(':AccessCard', $AccessCard);
    $stmt->bindParam(':FullName', $FullName);
    $stmt->bindParam(':Timestamp', date('Y-m-d H:i:s'));

    $stmt->execute();

}

// Funktion zum Updaten der PIC in den Dienstposten
function updatePositionPIC($positionID, $picID)
{

    include('config.inc.php');

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = "UPDATE Positions SET AccessCard = :picID WHERE ID = :positionID";

    $stmt = $pdo->prepare($sql);

    $stmt->bindParam(':positionID', $positionID);
    $stmt->bindParam(':picID', $picID);

    $stmt->execute();

}

// Funktion zur Ausgabe einer Meldung
function sweetAlert($title, $text, $icon)
{

    echo '
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                Swal.fire({
                    title: "' . $title . '",
                    text: "' . $text . '",
                    icon: "' . $icon . '"
                });
            });
        </script>';

}

// Erstellt eine Session-basierte Alert-Nachricht, die später angezeigt werden kann
// Parameter:
// $title - Der Titel des Alerts
// $text - Der Text bzw. die Nachricht des Alerts
// $icon - Das Symbol des Alerts (z. B. 'success', 'error', 'warning', 'question')
// Dieser Alert wird später angezeigt, wenn showSessionAlert() aufgerufen wird.
function createSessionAlert($title, $text, $icon, $button, $time)
{
    // Speichert die Alert-Daten in der Session, um sie später auf der Seite anzuzeigen
    $_SESSION['sessionAlert'] = [
        'title' => $title,
        'text' => $text,
        'icon' => $icon,
        'button' => $button,
        'time' => $time
    ];
}

// Zeigt den in der Session gespeicherten Alert an, falls vorhanden
// Nach der Anzeige wird der Alert aus der Session gelöscht
function showSessionAlert()
{
    // Prüft, ob eine Alert-Nachricht in der Session existiert
    if (isset($_SESSION['sessionAlert'])) {
        // Gibt die Meldung mittels SweetAlert aus
        echo '
            <script>
                document.addEventListener("DOMContentLoaded", function() {
                    Swal.fire({
                        title: "' . $_SESSION['sessionAlert']['title'] . '",
                        html: "' . $_SESSION['sessionAlert']['text'] . '",
                        icon: "' . $_SESSION['sessionAlert']['icon'] . '",
                        showConfirmButton: ' . $_SESSION['sessionAlert']['button'] . ',
                        timer: ' . $_SESSION['sessionAlert']['time'] . '
                    });
                });
            </script>';

        // Löscht den Alert aus der Session, um ihn nicht erneut anzuzeigen
        unset($_SESSION['sessionAlert']);
    }
}

// Ausgabe von Informationen zum Dienstposten ("Suchspalte", "Suche", "Ausgabespalte")
function getPositionDetails($positionWhere, $positionWhereParam, $positionDetail)
{

    include('config.inc.php');

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = "SELECT * FROM Positions WHERE $positionWhere = :positionWhereParam";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':positionWhereParam', $positionWhereParam);
    $stmt->execute();

    $getDetail = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($getDetail) {
        return $getDetail[$positionDetail];
    }

}

// Ausgabe von Informationen zu einer Zone
function getZoneDetails($zoneID, $zoneDetail)
{

    include('config.inc.php');

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = "SELECT * FROM Zones WHERE ZoneID = :zoneID";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':zoneID', $zoneID);
    $stmt->execute();

    $getDetail = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($getDetail) {
        return $getDetail[$zoneDetail];
    }

}

// Ausgabe von Informationen zur Identität
function getIdentityDetails($identityID, $identityDetail)
{

    include('config.inc.php');

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = "SELECT * FROM Identities WHERE ID = :identityID";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':identityID', $identityID);
    $stmt->execute();

    $getDetail = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($getDetail) {
        return $getDetail[$identityDetail];
    }

}

// Funktion zum Updaten von Informationen einer Identität (ID, Spalte, Wert)
function updateIdenty($identyID, $identyColumn, $identyValue)
{

    include('config.inc.php');

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = "UPDATE Identities SET $identyColumn = :identyValue WHERE ID = :identyID";

    $stmt = $pdo->prepare($sql);

    $stmt->bindParam(':identyValue', $identyValue);
    $stmt->bindParam(':identyID', $identyID);

    $stmt->execute();

}

// Funktion zum Updaten von Informationen eines Dienstposten (ID, Spalte, Wert)
function updatePosition($positionID, $positionColumn, $positionValue)
{

    include('config.inc.php');

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = "UPDATE Positions SET $positionColumn = :positionValue WHERE ID = :positionID";

    $stmt = $pdo->prepare($sql);

    $stmt->bindParam(':positionValue', $positionValue);
    $stmt->bindParam(':positionID', $positionID);

    $stmt->execute();

}

// Zählen von Identitäten welche derzeit im Einsatz sind (Militay, Civil, Local, Guest)
function countValidIdentities($Type = null)
{

    include('config.inc.php');

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = "
            SELECT COUNT(*)
            FROM Identities
            WHERE (NOW() BETWEEN IdentityIN AND IdentityOUT
               OR DATE(NOW()) = DATE(IdentityIN)
               OR DATE(NOW()) = DATE(IdentityOUT))
              AND AccessCard IS NOT NULL
              AND AccessCard != ''
        ";

    if (!empty($Type)) {
        $sql .= " AND Type = :Type";
    }

    $stmt = $pdo->prepare($sql);

    if (!empty($Type)) {
        $stmt->bindParam(':Type', $Type);
    }

    $stmt->execute();

    return $stmt->fetchColumn();
}

// Funktion zum Zählen von Datensätzen in einer Tabelle mithilfe eines optionalen Filters
function countDBEntries($tableName, $whereColumn = null, $whereValue = null)
{
    include('config.inc.php');

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Sicherheitsmaßnahmen: Entfernt Sonderzeichen aus dem Tabellennamen
    $tableName = preg_replace('/[^a-zA-Z0-9_]/', '', $tableName);

    // Prüfen, ob eine WHERE-Bedingung genutzt werden soll
    if (!empty($whereColumn) && !empty($whereValue)) {
        // WHERE-Spalte absichern
        $whereColumn = preg_replace('/[^a-zA-Z0-9_]/', '', $whereColumn);

        $sql = "SELECT COUNT(*) as totalCount FROM $tableName WHERE $whereColumn = :whereValue";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':whereValue', $whereValue);
    } else {
        // Keine WHERE-Bedingung → alle Datensätze
        $sql = "SELECT COUNT(*) as totalCount FROM $tableName";
        $stmt = $pdo->prepare($sql);
    }

    $stmt->execute();
    // Rückgabe als Integer
    return (int) $stmt->fetchColumn();
}

// Funktion zum Aktualisieren einer bestimmten Spalte in einer Tabelle anhand eines Filters
function updateDBEntry($tableName, $whereColumn, $whereValue, $updateColumn, $updateValue)
{
    include('config.inc.php');

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Sicherheitsmaßnahmen: Entfernt Sonderzeichen
    $tableName = preg_replace('/[^a-zA-Z0-9_]/', '', $tableName);
    $updateColumn = preg_replace('/[^a-zA-Z0-9_]/', '', $updateColumn);

    // Prüfen, ob wir überhaupt eine WHERE-Bedingung haben
    if (!empty($whereColumn) && !empty($whereValue)) {
        // WHERE-Bedingung verwenden
        $whereColumn = preg_replace('/[^a-zA-Z0-9_]/', '', $whereColumn);
        $sql = "UPDATE $tableName SET $updateColumn = :updateValue WHERE $whereColumn = :whereValue";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':updateValue', $updateValue);
        $stmt->bindParam(':whereValue', $whereValue);
    } else {
        // Keine WHERE-Bedingung → alle Zeilen aktualisieren
        $sql = "UPDATE $tableName SET $updateColumn = :updateValue";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':updateValue', $updateValue);
    }

    $stmt->execute();
}

// Funktion zum Löschen eines Datenbankeintrages
function deleteDBEntry($tableName, $whereColumn, $whereValue)
{
    include('config.inc.php');

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $tableName = preg_replace('/[^a-zA-Z0-9_]/', '', $tableName); // Entfernt Sonderzeichen
    $whereColumn = preg_replace('/[^a-zA-Z0-9_]/', '', $whereColumn);

    $sql = "DELETE FROM $tableName WHERE $whereColumn = :whereValue";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':whereValue', $whereValue);

    $stmt->execute();
}

// Funktion zur Ausgabe eines Datenbankeintrages
function getDBEntry($tableName, $whereColumn, $whereValue, $getColumn)
{

    include('config.inc.php');

    $dsn = "mysql:host={$mysql_config['host']};dbname={$mysql_config['database']};charset={$mysql_config['charset']}";
    $pdo = new PDO($dsn, $mysql_config['username'], $mysql_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = "SELECT * FROM $tableName WHERE $whereColumn = :whereValue";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':whereValue', $whereValue);
    $stmt->execute();

    $getDBEntry = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($getDBEntry) {
        return $getDBEntry[$getColumn];
    }

}

?>